<?php
/**
 * @Packge     : saor
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeforest.net/user/themeholy
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $saor404title     = saor_opt( 'saor_error_title' );
        $saor404subtitle     = saor_opt( 'saor_error_subtitle' );
        $saor404description  = saor_opt( 'saor_error_description' );
        $saor404btntext      = saor_opt( 'saor_error_btn_text' );
    } else {
        $saor404title     = __( 'Opp’s that page can’t be found', 'saor' );
        $saor404subtitle     = __( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'saor' );
        $saor404description  = __( 'We appologize for any distruction to the space-time continuum. Feel free to journey back to our homepage', 'saor' );
        $saor404btntext      = __( 'Go Back Home', 'saor');

    }

    // get header //
    get_header(); 

        echo '<section class="space">';
            echo '<div class="container">';
                echo '<div class="error-img">';
                    if(!empty(saor_opt('saor_error_img', 'url' ) )){
                        echo '<img src="'.esc_url( saor_opt('saor_error_img', 'url' ) ).'" alt="'.esc_attr__('404 image', 'saor').'">';
                    }else{
                        echo '<img src="'.get_template_directory_uri().'/assets/img/error.svg" alt="'.esc_attr__('404 image', 'saor').'">';
                    }
                echo '</div>';
                echo '<div class="error-content">';
                    if(!empty($saor404title)){
                        echo '<h2 class="error-title">'.esc_html( $saor404title ).'</h2>';
                    } 
                    if(!empty($saor404subtitle)){   
                        echo '<p class="error-text">'.esc_html( $saor404subtitle ).'</p>';
                    }    
                    echo '<a href="'.esc_url( home_url('/') ).'" class="th-btn th-black"><i class="fal fa-home me-2"></i>'.esc_html( $saor404btntext ).'</a>';
                echo '</div>';
            echo '</div>';
        echo '</section>';
    //footer
    get_footer();