<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class Saor_Image extends Widget_Base {

	public function get_name() {
		return 'saorimage';
	}
	public function get_title() {
		return __( 'Image', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five','Style Six','Style Seven','Style Eight','Style Nine','Style Ten','Style Eleven','Style Twelve','Style Thirteen'] );

		saor_general_fields( $this, 'experience', 'Experience', 'TEXT2', 'Experience', ['8'] );
		saor_general_fields( $this, 'number', 'Number', 'TEXT2', '20', ['8'] );
		saor_general_fields( $this, 'operator', 'Operator', 'TEXT2', '+', ['8'] );

		saor_media_fields( $this, 'image',  'Choose Image One',['1','2','3','4','5','6','7','8','9','10','11','12']);
		saor_media_fields( $this, 'image2', 'Choose Image Two',['3','6','8','9']);

		$this->add_control(
		    'image3',
		    [
		        'label' => esc_html__('Image Three', 'agrofa-addon'),
		        'type' => \Elementor\Controls_Manager::MEDIA,
		        'default' => [
		            'url' => \Elementor\Utils::get_placeholder_image_src(),
		        ],
		        'selectors' => [
		            '{{WRAPPER}} .img-box4 .img1:before' => 'background-image:url({{URL}});',
		        ],
		        'condition' => [
					'layout_style' => ['8']
				]
		    ]
		); 

       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------
		

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
       
		if( $settings['layout_style'] == '1' ){
			echo '<div class="img-box1 ps-xl-4">';
                echo '<div class="img1 th-anim">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					));
               echo ' </div>';
            echo '</div>';   
		}elseif( $settings['layout_style'] == '2'){
			echo '<div class="shape-mockup" data-top="0" data-left="0">';
	            echo '<div class="particle-2" id="particle-2"></div>';
	        echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			echo '<div class="shape-mockup" data-top="0" data-right="0">';
	            echo '<div class="particle-3" id="particle-3"></div>';
	        echo '</div>';
		}elseif($settings['layout_style'] == '4'){
			echo '<div class="img1 th-anim mb-35">';
                echo saor_img_tag( array(
					'url'   => esc_url( $settings['image']['url'] ),
				));
            echo '</div>';
		}elseif($settings['layout_style'] == '5'){
			echo '<div class="img1 th-anim">';
                echo saor_img_tag( array(
					'url'   => esc_url( $settings['image']['url'] ),
				));
            echo '</div>';
		}elseif($settings['layout_style'] == '6'){
			echo '<div class="choose-image">';
                echo '<div class="img1 tilt-active">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					));
                    echo '<div class="choose-shape">';
                    	echo saor_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						));
                    echo '</div>';
               echo '</div>';
            echo '</div>';
		}elseif($settings['layout_style'] == '7'){
			echo '<div class="testi-block-image tilt-active">';
                echo saor_img_tag( array(
					'url'   => esc_url( $settings['image']['url'] ),
				));
            echo '</div>';
        }elseif($settings['layout_style'] == '8'){
        	echo '<div class="img-box4">';
                echo '<div class="img1">';
                   	echo saor_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					));
                echo '</div>';
                echo '<div class="img2">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image2']['url'] ),
					));
               echo ' </div>';
                echo '<div class="th-experience">';
                	if(!empty($settings['number'])){
                    	echo '<h2 class="experience-year"><span class="counter-number">'.esc_html($settings['number']).'</span>'.esc_html($settings['operator']).'</h2>';
                    }
                    if(!empty($settings['experience'])){	
                    	echo '<p class="experience-text">'.esc_html($settings['experience']).'</p>';
                    }	
                echo '</div>';
            echo '</div>';
        }elseif($settings['layout_style'] == '9'){
        	 echo '<div class="img-box5">';
                echo '<div class="img1 th-anim">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					));
                echo '</div>';
                echo '<div class="img2 th-anim">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image2']['url'] ),
					));
                echo '</div>';
             echo '</div>';
        }elseif($settings['layout_style'] == '10'){
        	echo '<div class="img-box6">';
                echo '<div class="img1 th-anim">';
                    echo saor_img_tag( array(
						'url'   => esc_url( $settings['image']['url'] ),
					));
                echo '</div>';
            echo '</div>';
        }elseif($settings['layout_style'] == '11'){
        	echo '<div class="page-img global-img mb-50">';
                echo saor_img_tag( array(
					'url'   => esc_url( $settings['image']['url'] ),
				));
            echo '</div>';
        }elseif($settings['layout_style'] == '12'){
        	echo '<div class="mb-40 mb-xl-0">';
        		echo saor_img_tag( array(
					'url'   => esc_url( $settings['image']['url'] ),
					'class' => 'w-100'
				));
            echo '</div>';
        }
	}

} 