<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Countdown Widget .
 *
 */
class Saor_Countdown extends Widget_Base {

	public function get_name() {
		return 'saorcountdown';
	}
	public function get_title() {
		return __( 'Countdown', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Countdown', 'saor' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five'] ); 

        $counter_list = new Repeater();

        saor_general_fields($counter_list, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($counter_list, 'number', 'Number', 'TEXTAREA2', '12');
        saor_general_fields($counter_list, 'sufix', 'Sufix', 'TEXTAREA2', 'K');
        saor_general_fields($counter_list, 'prefix', 'Prefix', 'TEXTAREA2', '+');

        $this->add_control(
            'counter_list',
            [
                'label'         => __( 'Counter List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $counter_list->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['1','5']
                ]
            ]
        );

        $counter_list2 = new Repeater();

        saor_general_fields($counter_list2, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($counter_list2, 'number', 'Number', 'TEXTAREA2', '12');
        saor_general_fields($counter_list2, 'sufix', 'Sufix', 'TEXTAREA2', 'K');
        saor_general_fields($counter_list2, 'prefix', 'Prefix', 'TEXTAREA2', '+');
        saor_media_fields( $counter_list2, 'image', 'Icon Image' );

        $this->add_control(
            'counter_list2',
            [
                'label'         => __( 'Counter List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $counter_list2->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['2','4']
                ]
            ]
        );

        $counter_list3 = new Repeater();

        saor_general_fields($counter_list3, 'title', 'Title', 'TEXTAREA2', 'Default Title');
        saor_general_fields($counter_list3, 'number', 'Number', 'TEXTAREA2', '12');

        $this->add_control(
            'counter_list3',
            [
                'label'         => __( 'Counter List', 'saor' ),
                'type'          => Controls_Manager::REPEATER,
                'fields'        => $counter_list3->get_controls(),
                'title_field' => '{{{ title }}}',
                'condition' => [
                    'layout_style' => ['3']
                ]
            ]
        );

        $this->add_control(
            'subtitle_before_shape',
            [
                'label' => esc_html__('Subtitle Shape', 'agrofa-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'selectors' => [
                    '{{WRAPPER}} .counter-card-wrap .divider' => 'background-image:url({{URL}});',
                ],
                'condition' => [
                    'layout_style' => ['1']
                ]
            ]
        );

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
        //-------Title Style-------
        saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .counter-card .box-number,{{WRAPPER}} .counter-box h3,{{WRAPPER}} .feature-circle h3', ['1', '2', '3','5']);
        saor_common_style_fields( $this, 'subtitle', 'Sub-Title', '{{WRAPPER}} .text-white,{{WRAPPER}} .media-body p, {{WRAPPER}} .feature-circle .radial-progress text', ['1', '2', '3','5'] );
        //------Button Style (gradient-color)-------


	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

            echo '<div class="counter-card-wrap">';
                foreach( $settings['counter_list'] as $key => $data ){
                    echo '<div class="counter-card">';
                        echo '<h3 class="box-number"><span class="counter-number">'.esc_html($data['number']).'</span>'.esc_html($data['sufix']).'<span class="plus">'.esc_html($data['prefix']).'</span></h3>';
                        if(!empty($data['title'])){
                            echo '<div class="media-body">';
                                echo '<p class="counter-text mb-n1">'.esc_html($data['title']).'</p>';
                            echo '</div>';
                        }
                    echo '</div>';
                    echo '<div class="divider"></div>';
                }
            echo '</div>';

        }elseif($settings['layout_style'] == '2'){
            echo '<div class="counter-box-wrap">';
                foreach( $settings['counter_list2'] as $key => $data ){
                    echo '<div class="counter-box">';
                        echo '<div class="box-icon">';
                            echo saor_img_tag( array(
                                'url'   => esc_url( $data['image']['url'] ),
                            ));
                        echo '</div>';
                        if(!empty($data['number'])){
                            echo '<h3 class="box-number"><span class="counter-number">'.esc_html($data['number']).'</span><span class="plus">'.esc_html($data['sufix']).'</span></h3>';
                        }
                        if(!empty($data['title'])){    
                            echo '<div class="media-body">';
                                echo '<p class=" counter-text mb-n1">'.esc_html($data['title']).'</p>';
                            echo '</div>';
                        }    
                    echo '</div>';
                    echo '<div class="divider"></div>';
                }    
            echo '</div>';
        }elseif($settings['layout_style'] == '3'){

            echo '<div class="circle-counter">';
                foreach( $settings['counter_list3'] as $key => $data ){
                    echo '<div class="feature-circle">';
                        echo '<svg class="radial-progress" data-countervalue="80" viewBox="0 0 80 80">
                            <circle class="bar-static" cx="40" cy="40" r="35"></circle>
                            <circle class="bar--animated" cx="40" cy="40" r="35" style="stroke-dashoffset: 217.8;">
                            </circle>
                            <text class="countervalue start" x="50%" y="57%" transform="matrix(0, 1, -1, 0, 80, 0)">'.esc_html($data['number']).'</text>
                        </svg>';
                        if(!empty($data['title'])){
                            echo '<h3 class="feature-circle_title">'.esc_html($data['title']).'</h3>';
                        }    
                    echo '</div>';
                }
            echo '</div>';
        }elseif($settings['layout_style'] == '4'){
            echo '<div class="counter-item-wrap">';
                foreach( $settings['counter_list2'] as $key => $data ){
                    echo '<div class="counter-item">';
                        echo '<div class="box-icon">';
                            echo saor_img_tag( array(
                                'url'   => esc_url( $data['image']['url'] ),
                            ));
                        echo '</div>';
                        echo '<div class="media-body">';
                            echo '<h3 class="box-title"><span class="counter-number">'.esc_html($data['number']).'</span>'.esc_html($data['sufix']).' </h3>';
                            if(!empty($data['title'])){    
                                echo '<p class=" counter-text mb-0">'.esc_html($data['title']).'</p>';
                            }    
                        echo '</div>';
                    echo '</div>';
                }
            echo '</div>';
        }elseif($settings['layout_style'] == '5'){
            echo '<div class="counter-area2 overflow-hidden bg-title">';
                echo '<div class="container">';
                    echo '<div class="counter-box2-wrap">';
                        foreach( $settings['counter_list'] as $key => $data ){
                            echo '<div class="counter-box2">';
                                if(!empty($data['number'])){
                                    echo '<h2 class="box-number"><span class="counter-number">'.esc_html($data['number']).'</span>'.esc_html($data['sufix']).'<span class="plus">'.esc_html($data['prefix']).'</span></h2>';
                                }    
                                if(!empty($data['title'])){
                                    echo '<div class="media-body">';
                                        echo '<p class="box-text mb-n1">'.esc_html($data['title']).'</p>';
                                    echo '</div>';
                                }
                            echo '</div>';
                            echo '<div class="divider"></div>';
                        }    
                    echo '</div>';
                echo '</div>';
            echo '</div>';
        }

	
	}

}