<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * features Widget .
 *
 */
class Saor_About extends Widget_Base {

	public function get_name() {
		return 'saorabout';
	}
	public function get_title() {
		return __( 'About', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'About', 'saor' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five'] );

        saor_media_fields( $this, 'image1', 'Choose Image One', [ '1', '2','3','4'] );
		saor_media_fields( $this, 'image2', 'Choose Image Two', [ '1','3','4'] );
		saor_media_fields( $this, 'image3', 'Choose Image Three', [ '1','3'] );
		saor_media_fields( $this, 'image4', 'Choose Image Four', [ '1','3'] );
		saor_general_fields($this, 'title', 'Title', 'TEXTAREA2', 'Title', [ '1','2'] );
		saor_general_fields($this, 'year', 'Year', 'TEXTAREA2', 'Year', [ '2'] );
		saor_general_fields( $this, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-sharp fa-solid fa-play"></i>', [ '1']  );
		saor_url_fields( $this, 'video_url', 'Video URL', [ '1']  );
		saor_general_fields($this, 'button_label', 'Button Label', 'TEXTAREA2', 'Button Label', ['3','4'] );
		saor_url_fields( $this, 'button_url', 'URL', [ '3','4']  );

		$check_list = new Repeater();

		saor_general_fields($check_list, 'title', 'Title', 'TEXTAREA2', 'Title');
		saor_general_fields( $check_list, 'icon', 'Icon', 'TEXTAREA2', '<i class="fa-sharp fa-solid fa-play"></i>' );
		
		$this->add_control(
			'check_list',
			[
				'label' 		=> __( 'Check List', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $check_list->get_controls(),
				'default' 		=> [
					[
						'name' 	=> __( 'Check List', 'saor' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['5']
				]
			]
		);

		saor_general_fields( $this, 'experience', 'Experience', 'TEXT2', 'Experience', ['5'] );
		saor_general_fields( $this, 'number', 'Number', 'TEXT2', '20', ['5'] );
		saor_general_fields( $this, 'operator', 'Operator', 'TEXT2', '+', ['5'] );



        $this->end_controls_section();

        saor_common_style_fields($this, 'check_list', 'Check list Title', '{{WRAPPER}} .sec-title');
        saor_common_style_fields($this, 'number', 'Number', '{{WRAPPER}} .th-experience2 h2');
        saor_common_style_fields($this, 'experince_title', 'Experinace Title', '{{WRAPPER}} .experience-text');

        //---------------------------------------
			//Style Section Start
		//---------------------------------------


	}

	protected function render() {

    $settings = $this->get_settings_for_display(); 

		if( $settings['layout_style'] == '1' ){

            echo '<div class="about-wrapp">';
                echo '<div class="about-shape">';
                	echo saor_img_tag( array(
                        'url'   => esc_url( $settings['image1']['url'] ),
                    ) );
                echo '</div>';
                echo '<div class="discount-wrapp">';
                	if(!empty($settings['video_url']['url'])):
                   		echo '<a href="'.esc_url( $settings['video_url']['url'] ).'" class="play-btn popup-video">'.wp_kses_post($settings['icon']).'</a>';
                    endif;
                    if(!empty($settings['title'])):
	                    echo '<div class="discount-tag">';
	                        echo '<span class="discount-anime">'.esc_html($settings['title']).'</span>';
	                    echo ' </div>';
	                endif;    
                echo '</div>';
            echo '</div>';
            echo '<div class="img-box1 order-1">';
                echo '<div class="img1">';
                    echo saor_img_tag( array(
                        'url'   => esc_url( $settings['image2']['url'] ),
                    ) );
                echo '</div>';
            echo '</div>';

		}elseif($settings['layout_style'] == '2'){
			echo '<div class="row">';
                echo '<div class="col-12">';
                    echo '<div class="project-image th-anim">';
                        echo saor_img_tag( array(
	                        'url'   => esc_url( $settings['image1']['url'] ),
	                    ) );
                        echo '<div class="discount-wrapp">';
                        	if(!empty($settings['year'])):
                            	echo '<h2 class="project-counter"><span class="counter-number">'.esc_html($settings['year']).'</span></h2>';
                            endif;
                            if(!empty($settings['title'])):
	                            echo '<div class="discount-tag">';
	                                echo '<span class="discount-anime">'.esc_html($settings['title']).'</span>';
	                            echo '</div>';
	                        endif;    
                        echo '</div>';
                    echo '</div>';
                echo '</div>';
            echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			echo '<div class="process-wrapp">';
                echo '<div class="process-img">';
                	if(!empty($settings['image1']['url'])){
	                    echo '<div class="img1">';
	                    	echo saor_img_tag( array(
		                        'url'   => esc_url( $settings['image1']['url'] ),
		                    ) );
	                    echo '</div>';
	                }
	                if(!empty($settings['image2']['url'])){    
	                    echo '<div class="shape-1">';
	                   		echo saor_img_tag( array(
		                        'url'   => esc_url( $settings['image2']['url'] ),
		                    ) );
	                    echo '</div>';
	                }    
                echo '</div>';
                echo '<div class="process-img">';
                    echo '<div class="shape-2"></div>';
                    if(!empty($settings['image3']['url'])){ 
	                    echo '<div class="img1">';
	                    	echo saor_img_tag( array(
		                        'url'   => esc_url( $settings['image3']['url'] ),
		                    ) );
	                    echo '</div>';
	                }
	                if(!empty($settings['image4']['url'])){     
	                    echo '<div class="arrow text-center">';
	                        echo saor_img_tag( array(
		                        'url'   => esc_url( $settings['image4']['url'] ),
		                    ) );
	                    echo '</div>';
	                } 
	                if(!empty($settings['button_label'])){	   
	                    echo '<div class="sec-btn text-center">';
	                        echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn ser-btn th-icon">'.esc_html($settings['button_label']).'<i class="fa-regular fa-arrow-right ms-2"></i> </a>';
	                    echo '</div>';
	                }    
                echo '</div>';
            echo '</div>';
		}elseif($settings['layout_style'] == '4'){
			echo '<div class="btn-group about-btn justify-content-start">';
				if(!empty($settings['button_label'])){
		            echo '<a href="'.esc_url( $settings['button_url']['url'] ).'" class="th-btn th-icon th-radius">'.esc_html($settings['button_label']).'<i class="fa-regular fa-arrow-right ms-2"></i></a>';
		        }
	            echo '<div class="about-profile">';
	                echo '<div class="avater">';
	                    echo saor_img_tag( array(
	                        'url'   => esc_url( $settings['image1']['url'] ),
	                    ) );
	                echo '</div>';
	                echo '<div class="signature">';
	                    echo saor_img_tag( array(
	                        'url'   => esc_url( $settings['image2']['url'] ),
	                    ) );
	                echo '</div>';
	            echo '</div>';
	        echo '</div>';
	    }elseif($settings['layout_style'] == '5'){
	    	echo '<div class="about-wrapper">';
	    		if(!empty($settings['check_list'])){
	    			echo '<div class="checklist style3">';
	                    echo '<ul>';
	                    	foreach( $settings['check_list'] as $data ){
	                        	echo '<li>'. wp_kses_post( $data['icon'] ).''.esc_html($data['title']).'</li>';
	                        }
	                    echo '</ul>';
	                echo '</div>';
	    		}
                echo '<div class="divider"></div>';
                if(!empty($settings['experience'] || $settings['number'])){
                	echo '<div class="th-experience2">';
	                    echo '<h2 class="experience-year"><span class="counter-number">'.esc_html($settings['number']).'</span>'.esc_html($settings['operator']).'</h2>';
	                   echo ' <p class="experience-text">'.esc_html($settings['experience']).'</p>';
	                echo '</div>';
                }
            echo '</div>';
		}
	}
}