<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Testimonial Slider Widget .
 *
 */
class Saor_Testimonial extends Widget_Base{

	public function get_name() {
		return 'saortestimonialslider';
	}
	public function get_title() {
		return __( 'Testimonials', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'saor' ), 
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One','Style Two','Style Three','Style Four','Style Five'] );

		$repeater = new Repeater();

		saor_media_fields( $repeater, 'client_image', 'Client Image' );
		saor_general_fields( $repeater, 'client_name', 'Client Name', 'TEXT', 'Alex Michel' );
		saor_general_fields( $repeater, 'client_desig', 'Client Designation', 'TEXT', 'Ui/Ux Designer' );
		saor_general_fields( $repeater, 'client_feedback', 'Client Feedback', 'TEXTAREA', 'Client Feedback' );
		saor_select_field( $repeater, 'client_rating', 'Client Rating', [ 'One Star', 'Two Star', 'Three Star', 'Four Star', 'Five Star' ] );

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '1','3','4','5'],
				],
			]
		);


		$slides2 = new Repeater();
		
		saor_general_fields( $slides2, 'title', 'Title', 'TEXT', 'Title' );
		saor_general_fields( $slides2, 'content', 'Content', 'TEXT', 'Content' );
		saor_general_fields( $slides2, 'client_name', 'Client Name', 'TEXT', 'Alex Michel' );
		saor_general_fields( $slides2, 'client_desig', 'Client Designation', 'TEXT', 'Ui/Ux Designer' );
		saor_media_fields( $slides2, 'client_image', 'Client Image' );
		saor_media_fields( $slides2, 'logo_image', 'Logo Image' );
	
		$this->add_control(
			'slides2',
			[
				'label' 		=> __( 'Slides', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $slides2->get_controls(),
				'default' 		=> [
					[
						'client_image'	=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
				'condition'		=> [ 
					'layout_style' => [ '2'],
				],
			]
		);

		saor_media_fields( $this, 'shape_image', 'Shape Image',['2','3']);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		saor_common_style_fields( $this, '01', 'Name', '{{WRAPPER}} .box-title' );
		saor_common_style_fields( $this, '02', 'Designation', '{{WRAPPER}} .box-desig' );
		saor_common_style_fields( $this, '03', 'Feedback', '{{WRAPPER}} .box-text' );
		
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

 			echo '<div class="slider-area">';
                echo '<div class="swiper th-slider has-shadow" id="testiSlide1" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"2"},"1300":{"slidesPerView":"3"}}}\'>';
                   echo ' <div class="swiper-wrapper">';
                    	foreach( $settings['slides'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="testi-card">';
	                                echo '<div class="box-review">';

	                                   if( $data['client_rating'] == '1' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '2' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '3' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '4' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}else{
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
										}

	                                echo '</div>';
	                                echo '<p class="box-text">“'.esc_html( $data['client_feedback'] ).'”</p>';
	                                echo '<div class="box-wrapp">';
	                                    echo '<div class="box-profile">';
	                                        echo '<div class="box-author">';
	                                           	echo saor_img_tag( array(
													'url'	=> esc_url( $data['client_image']['url'] )
												) );
	                                        echo '</div>';
	                                        echo '<div class="box-info">';
	                                        	if(!empty($data['client_name'])){
	                                            	echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
	                                            }
	                                            if(!empty($data['client_desig'])){	
	                                            	echo '<span class="box-desig">'.esc_html( $data['client_desig'] ).'</span>';
	                                            }	
	                                       echo ' </div>';
	                                   echo ' </div>';
	                               echo ' </div>';
	                            echo '</div>';
	                       echo ' </div>';
                        }

                   echo ' </div>';
                echo '</div>';
                echo '<button data-slider-prev="#testiSlide1" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#testiSlide1" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';

		}elseif($settings['layout_style'] == '2'){

			echo '<div class="slider-area testi-box-area">';
                echo '<div class="swiper th-slider has-shadow testiSlider2" id="testiSlide2" data-slider-options=\'{"effect":"fade","loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}\'>';
                    echo '<div class="swiper-wrapper">';
                    	foreach( $settings['slides2'] as $data ){
	                        echo '<div class="swiper-slide">';
	                            echo '<div class="testi-grid">';
	                                echo '<div class="box-content">';
	                                    echo '<div class="testi-logo">';
	                                        echo saor_img_tag( array(
												'url'	=> esc_url( $data['logo_image']['url'] )
											) );
	                                    echo ' </div>';
	                                    if(!empty($data['title'])){	
	                                    	echo '<h3 class="box-title2">'.esc_html( $data['title'] ).'</h3>';
	                                    }	
	                                    if(!empty($data['content'])){	
	                                    	echo '<p class="box-text">'.esc_html( $data['content'] ).'</p>';
	                                    }	
	                                    if(!empty($data['client_name'])){	
	                                    	echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
	                                  	}	
	                                    if(!empty($data['client_desig'])){
	                                    	echo '<span class="box-desig">'.esc_html( $data['client_desig'] ).'</span>';
	                                    }	
	                                echo '</div>';
	                                echo '<div class="box-img">';
	                                    echo saor_img_tag( array(
											'url'	=> esc_url( $data['client_image']['url'] )
										) );
	                                echo '</div>';
	                            echo '</div>';
	                        echo '</div>';
                        }
                    echo '</div>';
               echo ' </div>';
                echo '<button data-slider-prev="#testiSlide2" class="slider-arrow style3 slider-prev"><i class="far fa-arrow-left"></i></button>';
                echo '<button data-slider-next="#testiSlide2" class="slider-arrow style3 slider-next"><i class="far fa-arrow-right"></i></button>';
            echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			echo '<div class="swiper th-slider has-shadow testi-slider4" data-slider-options=\'{"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"1"},"992":{"slidesPerView":"1"},"1200":{"slidesPerView":"1"}}}\'>';
                echo '<div class="swiper-wrapper">';
                	foreach( $settings['slides'] as $data ){
	                    echo '<div class="swiper-slide">';
	                        echo '<div class="testi-block">';
	                            echo '<div class="testi-wrapp">';
	                                echo '<div class="box-avater">';
	                                    echo saor_img_tag( array(
											'url'	=> esc_url( $data['client_image']['url'] )
										) );
	                                echo '</div>';
	                                echo '<div class="box-review">';
	                                    if( $data['client_rating'] == '1' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '2' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '3' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}elseif( $data['client_rating'] == '4' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
										}else{
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fas fa-star"></i>';
										}
	                                echo '</div>';
	                            echo '</div>';
	                            if(!empty($data['client_feedback'])){	
                                	echo '<p class="box-text">'.esc_html( $data['client_feedback'] ).'</p>';
                                }
	                            echo '<div class="box-profile">';
	                                echo '<div class="media-body">';
	                                    if(!empty($data['client_name'])){	
	                                    	echo '<h3 class="box-title2">'.esc_html( $data['client_name'] ).'</h3>';
	                                    }	
	                                    if(!empty($data['client_desig'])){	
	                                    	echo '<p class="box-text">'.esc_html( $data['client_desig'] ).'</p>';
	                                    }
	                                echo '</div>';
	                            echo '</div>';
	                            if(!empty($settings['shape_image']['url'])){
	                            	echo '<div class="testi-quote">';
		                                echo saor_img_tag( array(
											'url'	=> esc_url( $settings['shape_image']['url'] )
										) );
		                            echo '</div>';
	                            }
	                           

	                        echo '</div>';
	                    echo '</div>';
                    }
                echo '</div>';
                echo '<div class="slider-pagination"></div>';
            echo '</div>';
		}elseif($settings['layout_style'] == '4'){

             echo '<div class="slider-area testi-box-area">';
                 echo '<div class="swiper th-slider has-shadow testiSlider3" id="testiSlide3" data-slider-options=\'{"centeredSlides":true,"loop":true,"breakpoints":{"0":{"slidesPerView":1},"576":{"slidesPerView":"1"},"768":{"slidesPerView":"2"},"992":{"slidesPerView":"2"},"1200":{"slidesPerView":"3"},"1400":{"slidesPerView":"3"}}}\'>';
                     echo '<div class="swiper-wrapper">';
                     	foreach( $settings['slides'] as $data ){
	                        echo '<div class="swiper-slide">';
	                             echo '<div class="testi-box th-ani">';
	                                if(!empty($data['client_feedback'])){	
                                    	echo '<p class="box-text">'.esc_html( $data['client_feedback'] ).'</p>';
                                    }	
	                                echo '<div class="box-wrapper">';
	                                     echo '<div class="box-profile">';
	                                        echo '<div class="box-author">';
	                                            echo saor_img_tag( array(
													'url'	=> esc_url( $data['client_image']['url'] )
												) );
	                                        echo '</div>';
	                                        echo '<div class="box-info">';
	                                            if(!empty($data['client_name'])){	
			                                    	echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
			                                  	}	
			                                    if(!empty($data['client_desig'])){
			                                    	echo '<span class="box-desig">'.esc_html( $data['client_desig'] ).'</span>';
			                                    }	
	                                        echo '</div>';
	                                     echo '</div>';
	                                     echo '<div class="box-review">';
	                                        if( $data['client_rating'] == '1' ){
											echo '<i class="fas fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '2' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '3' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '4' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}else{
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
											}
	                                     echo '</div>';
	                                 echo '</div>';
	                             echo '</div>';
	                        echo '</div>';
                        }
                     echo '</div>';
                     echo '<div class="slider-pagination"></div>';
                     echo '<button data-slider-prev="#testiSlide3" class="slider-arrow slider-prev"><i class="far fa-arrow-left"></i></button>';
                     echo '<button data-slider-next="#testiSlide3" class="slider-arrow slider-next"><i class="far fa-arrow-right"></i></button>';
                 echo '</div>';
             echo '</div>';
        
		}elseif($settings['layout_style'] == '5'){
			echo '<div class="row gy-40">';
				foreach( $settings['slides'] as $data ){
	                echo '<div class="col-lg-6 col-xl-4">';
	                    echo '<div class="testi-item th-ani">';
	                        echo '<p class="box-text">'.esc_html( $data['client_feedback'] ).'</p>';
	                        echo ' <div class="box-profile">';
	                            echo '<div class="box-author">';
	                                echo saor_img_tag( array(
										'url'	=> esc_url( $data['client_image']['url'] )
									) );
	                            echo '</div>';
	                            echo '<div class="box-info">';
	                                if(!empty($data['client_name'])){	
                                    	echo '<h3 class="box-title">'.esc_html( $data['client_name'] ).'</h3>';
                                  	}	
                                    if(!empty($data['client_desig'])){
                                    	echo '<span class="box-desig">'.esc_html( $data['client_desig'] ).'</span>';
                                    }	
	                                echo '<div class="box-review">';
		                                    if( $data['client_rating'] == '1' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '2' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '3' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}elseif( $data['client_rating'] == '4' ){
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fa-regular fa-star"></i>';
											}else{
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
												echo '<i class="fas fa-star"></i>';
											}
	                                echo '</div>';
	                            echo '</div>';
	                       echo ' </div>';
	                    echo '</div>';
	               echo ' </div>';
                }
            echo '</div>';
		}


	}

}