<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class Saor_Subscribe extends Widget_Base{

	public function get_name() {
		return 'saor_subscribe';
	}
	public function get_title() {
		return esc_html__( 'Subscribe', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'footer_subscribe_content',
			[
				'label'		=> esc_html__( 'Subscribe','saor' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		saor_select_field( $this, 'layout_style', 'Layout Style', [ 'Style One' ,'Style Two'] );

		saor_general_fields( $this, 'placeholder_text', 'Placeholder Text', 'TEXT', 'Placeholder Text', ['1','2'] );
		saor_general_fields( $this, 'button_text', 'Button Text', 'TEXT', 'Button Text', ['1','2'] );

		$this->end_controls_section();

		saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .brand-title2' );
	}

	protected function render() {

	$settings = $this->get_settings_for_display(); 

		if($settings['layout_style'] == '1'){

            echo '<form class="newsletter-form style4">';
                echo '<input class="form-control" type="email" placeholder="'.esc_html($settings['placeholder_text']).'" required="">';
                echo '<button type="submit" class="th-btn style4 th-icon">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></button>';
            echo '</form>';
		}elseif($settings['layout_style'] == '2'){
			echo '<form class="newsletter-form style4">';
                echo '<input class="form-control" type="email" placeholder="'.esc_html($settings['placeholder_text']).'" required="">';
                echo ' <button type="submit" class="th-btn style1">'.esc_html($settings['button_text']).'<i class="fa-regular fa-arrow-right ms-2"></i></button>';
            echo '</form>';
		}
		
		
	}
}