<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Step Widget .
 *
 */
class Saor_Sliding_Text extends Widget_Base {

	public function get_name() {
		return 'saorsliding';
	}
	public function get_title() {
		return __( 'Sliding Text', 'saor' );
	}
	public function get_icon() {
		return 'th-icon';
    }
	public function get_categories() {
		return [ 'saor' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Sliding Content', 'saor' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
			]
        );

		saor_select_field( $this, 'layout_style', 'Layout Style',['Style One','Style Two','Style Three','Style Four','Style Five'] );

		$repeater = new Repeater();

		saor_media_fields($repeater, 'image', 'Choose Image');
		saor_general_fields($repeater, 'title', 'Title', 'TEXTAREA2', 'Default Title');

		$this->add_control(
			'sliding_list',
			[
				'label' 		=> __( 'Sliding Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['1','2','3','4']
				]
			]
		);

		$sliding_list2 = new Repeater();

		saor_media_fields($sliding_list2, 'image', 'Choose Image');
		saor_general_fields($sliding_list2, 'title', 'Title', 'TEXTAREA2', 'Default Title');
		saor_url_fields($sliding_list2, 'video_url', 'Video URL');

		$this->add_control(
			'sliding_list2',
			[
				'label' 		=> __( 'Sliding Lists', 'saor' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $sliding_list2->get_controls(),
				'title_field' => '{{{ title }}}',
				'condition'	=> [
					'layout_style' => ['5']
				]
			]
		);

        $this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		//-------Title Style-------
		saor_common_style_fields( $this, 'title', 'Title', '{{WRAPPER}} .marquee-item,{{WRAPPER}} .marquee .marquee-group .item' );

	}

	protected function render() {

	$settings = $this->get_settings_for_display();

		if( $settings['layout_style'] == '1' ){

		    echo '<div class="marquee-area">';
		        echo '<div class="marquee-content positive-relative overflow-hidden">';
		            echo '<div class="marquee">';
		                echo '<div class="marquee-group">';
		                	foreach( $settings['sliding_list'] as $key => $data ){
		                    	echo '<div class="item">';
		                    		echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
		                    		echo '<span>'.esc_html($data['title']).'</span>';
		                    	echo '</div>';
		                    }
		                echo '</div>';
		                echo '<div aria-hidden="true" class="marquee-group">';
	                   		foreach( $settings['sliding_list'] as $key => $data ){
		                    	echo '<div class="item">';
		                    		echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
		                    		echo '<span>'.esc_html($data['title']).'</span>';
		                    	echo '</div>';
		                    }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '2'){

			echo '<div class="marquee-area2 bg-theme position-relative overflow-hidden pt-60 pb-60">';
		        echo '<div class="marquee">';
		            echo '<div class="marquee-group style4">';
		            	foreach( $settings['sliding_list'] as $key => $data ){
			                echo '<div class="item">';
				                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
				                echo '<span>'.esc_html($data['title']).'</span>';
			                echo '</div>';
		               	}

		            echo '</div>';
		            echo '<div aria-hidden="true" class="marquee-group style4">';

		                foreach( $settings['sliding_list'] as $key => $data ){
			                echo '<div class="item">';
				                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
				                echo '<span>'.esc_html($data['title']).'</span>';
			                echo '</div>';
		               	}
		                
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '3'){
			echo '<div class="marquee-area style3 bg-smoke2">';
		        echo '<div class="marquee-content positive-relative overflow-hidden">';
		            echo '<div class="marquee">';
		                echo '<div class="marquee-group style3">';
		                    foreach( $settings['sliding_list'] as $key => $data ){
				                echo '<div class="item">';
					                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
					                echo '<span>'.esc_html($data['title']).'</span>';
				                echo '</div>';
			               	} 
		                echo '</div>';
		                echo '<div aria-hidden="true" class="marquee-group style3">';
		                    foreach( $settings['sliding_list'] as $key => $data ){
				                echo '<div class="item">';
					                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
					                echo '<span>'.esc_html($data['title']).'</span>';
				                echo '</div>';
			               	}
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '4'){

			echo '<div class="marquee-area2 bg-theme position-relative overflow-hidden pt-30 pb-30">';
		        echo '<div class="marquee">';
		            echo '<div class="marquee-group style4">';
		                foreach( $settings['sliding_list'] as $key => $data ){
			                echo '<div class="item">';
				                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
				                echo '<span>'.esc_html($data['title']).'</span>';
			                echo '</div>';
		               	}
		            echo '</div>';
		            echo '<div aria-hidden="true" class="marquee-group style4">';
		                foreach( $settings['sliding_list'] as $key => $data ){
			                echo '<div class="item">';
				                echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
				                echo '<span>'.esc_html($data['title']).'</span>';
			                echo '</div>';
		               	}
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}elseif($settings['layout_style'] == '5'){
			echo '<div class="marquee-area">';
		        echo '<div class="marquee-content positive-relative overflow-hidden">';
		            echo '<div class="marquee">';
		                echo '<div class="marquee-group style2">';
		                	foreach( $settings['sliding_list2'] as $key => $data ){
			                    echo '<div class="item">';
			                        echo '<div class="video-img">';
			                        if(!empty($data['image']['url'])):
			                        	echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
 									endif;
			                        if(!empty($data['title'])):
			                        	echo '<a href="'.$data['video_url']['url'].'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a></div>';
			                        	echo '<span>'.esc_html($data['title']).'</span>';
			                        endif;	
			                    echo '</div>';
		                    }
		                echo ' </div>';
		                echo '<div aria-hidden="true" class="marquee-group style2">';
		                	foreach( $settings['sliding_list2'] as $key => $data ){
			                    echo '<div class="item">';
			                        echo '<div class="video-img">';
			                        if(!empty($data['image']['url'])):
			                        	echo '<img src="'.$data['image']['url'].'" alt="'.esc_attr(get_bloginfo('name')).'">';
 									endif;
			                        if(!empty($data['title'])):
			                        	echo '<a href="'.$data['video_url']['url'].'" class="play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a></div>';
			                        	echo '<span>'.esc_html($data['title']).'</span>';
			                        endif;	
			                    echo '</div>';
		                    }
		                echo '</div>';
		            echo '</div>';
		        echo '</div>';
		    echo '</div>';
		}
	

	}

}